/* Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
All rights reserved. */
 
/* 
   NAME 
     cdemoclid.h - OCI sample program to set/retrieve client identifier 

   DESCRIPTION 
     Header file of cdemoclid.c
   
   MODIFIED   (MM/DD/YY)
   ssonawan    05/29/09 - Creation

*/

#ifndef CDEMOCLID_ORACLE
# define CDEMOCLID_ORACLE

#ifndef OCI_ORACLE
#include <oci.h> 
#endif

#include <stdio.h>

/*---------------------------------------------------------------------------
                     PUBLIC TYPES AND CONSTANTS
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
                     PRIVATE TYPES AND CONSTANTS
  ---------------------------------------------------------------------------*/
static char *selci = (char *)
            "SELECT sys_context('userenv', 'client_identifier') from dual";

static OCIEnv *envhp; 
static OCIError *errhp;
            
/*---------------------------------------------------------------------------
                           EXPORT FUNCTIONS
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
                          INTERNAL FUNCTIONS
  ---------------------------------------------------------------------------*/
void parse_connect_string(char* connect_str, char* username,
                          char* password,    char* dbname);
void checkerr(OCIError *errhp, int lineno, sword status);
void report_error(OCIError *errhp);

#endif                                              /* CDEMOCLID_ORACLE */
